-- StreamTube Database Schema
-- Run this in your MySQL database

CREATE DATABASE IF NOT EXISTS streamtube;
USE streamtube;

-- Users table
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    avatar VARCHAR(255) DEFAULT '/assets/default-avatar.png',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Videos table
CREATE TABLE IF NOT EXISTS videos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    thumbnail VARCHAR(255) NOT NULL,
    video_url VARCHAR(255) NOT NULL,
    duration VARCHAR(10) DEFAULT '0:00',
    views INT DEFAULT 0,
    category VARCHAR(50) DEFAULT 'General',
    tags VARCHAR(255),
    uploaded_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (uploaded_by) REFERENCES users(id) ON DELETE SET NULL
);

-- Watch history table
CREATE TABLE IF NOT EXISTS watch_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    video_id INT NOT NULL,
    watched_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    progress INT DEFAULT 0,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (video_id) REFERENCES videos(id) ON DELETE CASCADE,
    UNIQUE KEY unique_history (user_id, video_id)
);

-- Favorites table
CREATE TABLE IF NOT EXISTS favorites (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    video_id INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (video_id) REFERENCES videos(id) ON DELETE CASCADE,
    UNIQUE KEY unique_favorite (user_id, video_id)
);

-- Insert sample videos
INSERT INTO videos (title, description, thumbnail, video_url, duration, views, category, tags) VALUES
('Spider-Man: No Way Home Trailer', 'The stakes become dangerous when Peter Parker discovers what it truly means to be Spider-Man', '/placeholder.svg?height=400&width=700', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4', '2:30', 15000000, 'Movies', 'marvel,action,superhero'),
('Loki Season 1 (2022)', 'The first season of the American television series about the God of Mischief', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ElephantsDream.mp4', '45:00', 8500000, 'Series', 'marvel,loki,disney'),
('Peacemaker (2022)', 'Peacemaker is a superhero comedy-drama television series', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerBlazes.mp4', '42:00', 6200000, 'Series', 'dc,comedy,action'),
('John Wick 4 (2023)', 'Hit man John Wick takes his fight against the High Table global', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4', '2:49', 12000000, 'Movies', 'action,keanu,thriller'),
('John Wick 3 (2022)', 'John Wick is on the run after killing a member of the High Table', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerFun.mp4', '2:10', 9800000, 'Movies', 'action,keanu,thriller'),
('Friends Complete Series', 'Follow the lives of six reckless adults living in Manhattan', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerJoyrides.mp4', '22:00', 25000000, 'Series', 'comedy,sitcom,friends'),
('Deadpool 3 Announcement', 'Ryan Reynolds announces Deadpool 3 with Hugh Jackman', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerMeltdowns.mp4', '3:15', 18000000, 'Movies', 'marvel,deadpool,wolverine'),
('The Flash (2023)', 'Barry Allen uses his super speed to change the past', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/Sintel.mp4', '2:24', 7500000, 'Movies', 'dc,flash,superhero'),
('Stranger Things S4', 'The fourth season of the American science fiction horror drama', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/SubaruOutbackOnStreetAndDirt.mp4', '1:20:00', 32000000, 'Series', 'horror,scifi,netflix'),
('Breaking Bad', 'A high school chemistry teacher turned methamphetamine producer', '/placeholder.svg?height=200&width=350', 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/TearsOfSteel.mp4', '47:00', 45000000, 'Series', 'drama,crime,amc');
