<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? 'list';

switch ($action) {
    case 'list':
        getVideos();
        break;
    case 'get':
        getVideo($_GET['id'] ?? 0);
        break;
    case 'trending':
        getTrending();
        break;
    case 'search':
        searchVideos($_GET['q'] ?? '');
        break;
    case 'category':
        getByCategory($_GET['cat'] ?? '');
        break;
    case 'view':
        if ($method === 'POST') {
            incrementView();
        }
        break;
    default:
        echo json_encode(['error' => 'Invalid action']);
}

function getVideos() {
    $conn = getDBConnection();
    $query = "SELECT v.*, u.username as uploader_name FROM videos v 
              LEFT JOIN users u ON v.uploaded_by = u.id 
              ORDER BY v.created_at DESC";
    $result = $conn->query($query);
    
    $videos = [];
    while ($row = $result->fetch_assoc()) {
        $videos[] = $row;
    }
    
    echo json_encode($videos);
    $conn->close();
}

function getVideo($id) {
    $conn = getDBConnection();
    $query = "SELECT v.*, u.username as uploader_name FROM videos v 
              LEFT JOIN users u ON v.uploaded_by = u.id 
              WHERE v.id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        echo json_encode($result->fetch_assoc());
    } else {
        echo json_encode(['error' => 'Video not found']);
    }
    
    $conn->close();
}

function getTrending() {
    $conn = getDBConnection();
    $query = "SELECT v.*, u.username as uploader_name FROM videos v 
              LEFT JOIN users u ON v.uploaded_by = u.id 
              ORDER BY v.views DESC LIMIT 10";
    $result = $conn->query($query);
    
    $videos = [];
    while ($row = $result->fetch_assoc()) {
        $videos[] = $row;
    }
    
    echo json_encode($videos);
    $conn->close();
}

function searchVideos($query) {
    $conn = getDBConnection();
    $searchTerm = '%' . $conn->real_escape_string($query) . '%';
    
    $sql = "SELECT v.*, u.username as uploader_name FROM videos v 
            LEFT JOIN users u ON v.uploaded_by = u.id 
            WHERE v.title LIKE ? OR v.description LIKE ? OR v.tags LIKE ?
            ORDER BY v.views DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $searchTerm, $searchTerm, $searchTerm);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $videos = [];
    while ($row = $result->fetch_assoc()) {
        $videos[] = $row;
    }
    
    echo json_encode($videos);
    $conn->close();
}

function getByCategory($category) {
    $conn = getDBConnection();
    $query = "SELECT v.*, u.username as uploader_name FROM videos v 
              LEFT JOIN users u ON v.uploaded_by = u.id 
              WHERE v.category = ?
              ORDER BY v.created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $category);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $videos = [];
    while ($row = $result->fetch_assoc()) {
        $videos[] = $row;
    }
    
    echo json_encode($videos);
    $conn->close();
}

function incrementView() {
    $conn = getDBConnection();
    $data = json_decode(file_get_contents('php://input'), true);
    $videoId = $data['video_id'] ?? 0;
    
    $query = "UPDATE videos SET views = views + 1 WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $videoId);
    $stmt->execute();
    
    // Add to history if user is logged in
    if (isset($_SESSION['user_id'])) {
        $userId = $_SESSION['user_id'];
        $historyQuery = "INSERT INTO watch_history (user_id, video_id) VALUES (?, ?)
                         ON DUPLICATE KEY UPDATE watched_at = CURRENT_TIMESTAMP";
        $stmt = $conn->prepare($historyQuery);
        $stmt->bind_param("ii", $userId, $videoId);
        $stmt->execute();
    }
    
    echo json_encode(['success' => true]);
    $conn->close();
}
?>
